/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
namespace Inet.Viewer.Data
{
    /// <summary>
    /// Encapsulates the Properties needed for the Adornment: The Linestyles for each line seperately and the lineWidth.
    /// If an ellipse should be rendered the width and the height of the ellipse. To set if a shadow should be drawn or not.
    /// 
    /// The unit is depending on the Graphics, which could be either pixel or twips.
    /// </summary>
    internal class Adornment
    {
        private LineStyle leftStyle;
        private LineStyle rightStyle;
        private LineStyle topStyle;
        private LineStyle bottomStyle;
        private int lineWidth;
        private int ellipseWidth;
        private int ellipseHeight;
        private bool showShadow;

        /// <summary>
        /// Default constructor
        /// </summary>
        internal Adornment()
        {
        }

        /// <summary>
        /// Gets or sets line style for the line on the left
        /// </summary>
        internal LineStyle LeftStyle
        {
            get { return leftStyle; }
            set { leftStyle = value; }
        }

        /// <summary>
        /// Gets or sets the line style for the line on the right 
        /// </summary>
        internal LineStyle RightStyle
        {
            get { return rightStyle; }
            set { rightStyle = value; }
        }

        /// <summary>
        /// Gets or sets the line style for the line on the top
        /// </summary>
        internal LineStyle TopStyle
        {
            get { return topStyle; }
            set { topStyle = value; }
        }

        /// <summary>
        /// Gets or sets the line style for the line on the bottom
        /// </summary>
        internal LineStyle BottomStyle
        {
            get { return bottomStyle; }
            set { bottomStyle = value; }
        }

        /// <summary>
        /// Gets or sets the width of the line. Pixel or twips depending on the graphics
        /// </summary>
        internal int LineWidth
        {
            get { return lineWidth; }
            set { lineWidth = value; }
        }

        /// <summary>
        /// Gets or sets the width of the ellipse. Pixel or twips depending on the graphics
        /// </summary>
        internal int EllipseWidth
        {
            get { return ellipseWidth; }
            set { ellipseWidth = value; }
        }

        /// <summary>
        /// Gets or sets the height of the ellipse. Pixel or twips depending on the graphics
        /// </summary>
        internal int EllipseHeight
        {
            get { return ellipseHeight; }
            set { ellipseHeight = value; }
        }

        /// <summary>
        /// Gets or sets a flag indicating whether a shadow should be drawn
        /// </summary>
        internal bool ShowShadow
        {
            get { return showShadow; }
            set { showShadow = value; }
        }

        /// <summary>
        /// Constructor to set all values of this Adornment class
        /// </summary>
        /// <param name="leftStyle"></param>
        /// <param name="rightStyle"></param>
        /// <param name="topStyle"></param>
        /// <param name="bottomStyle"></param>
        /// <param name="lineWidth"></param>
        /// <param name="ellipseWidth"></param>
        /// <param name="ellipseHeight"></param>
        /// <param name="showShadow"></param>
        internal Adornment(LineStyle leftStyle, LineStyle rightStyle, LineStyle topStyle, LineStyle bottomStyle, int lineWidth, int ellipseWidth, int ellipseHeight, bool showShadow)
        {
            this.leftStyle = leftStyle;
            this.rightStyle = rightStyle;
            this.topStyle = topStyle;
            this.bottomStyle = bottomStyle;
            this.lineWidth = lineWidth;
            this.ellipseWidth = ellipseWidth;
            this.ellipseHeight = ellipseHeight;
            this.showShadow = showShadow;
        }
    }
}